#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/totwc/header.h"
#include "levels/bbh/header.h"

extern u8 _totwc_segment_ESegmentRomStart[];
extern u8 _totwc_segment_ESegmentRomEnd[];

const LevelScript level_totwc_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _totwc_segment_ESegmentRomStart, _totwc_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group8_mio0SegmentRomStart, _group8_mio0SegmentRomEnd),
LOAD_RAW(12, _group8_geoSegmentRomStart, _group8_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(84, 0x05002e00, 4),
// LOAD_MODEL_FROM_DL(86, 0x05003120, 4),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_9),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_totwc_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_totwc_1_[] = {
AREA(1, Geo_totwc_1_0x1aa18b0),
TERRAIN(col_totwc_1_0xe041c80),
SET_BACKGROUND_MUSIC(0, 47),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_totwc_1_),
JUMP_LINK(local_warps_totwc_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_totwc_1_[] = {
OBJECT_WITH_ACTS(0, 6889, -1981, -3386, 0, 270, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 1799, 1209, 6769, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -7273, -1599, -3634, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -7100, 705, 7800, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 887, -897, -258, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -2495, 3387, 6499, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(215, -5752, -627, -5946, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2055, -537, -806, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -456, 900, -4070, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2160, -321, 3462, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5030, 3612, -3422, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -7252, 690, -1558, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4953, 942, -3266, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4331, -611, -2384, 0, 270, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -7380, 0, -5937, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(0, 6696, -1445, 4367, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, 6696, -1445, 4367, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 6603, -2527, 1467, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, 6603, -2527, 1467, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 6718, -1370, 6024, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, 6718, -1370, 6024, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 6705, -1370, 5107, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, 6705, -1370, 5107, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 6728, -1370, 3180, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, 6728, -1370, 3180, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 5151, -441, 7193, 0, 0, 0, 0x6000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(85, 994, 3498, -5171, 0, 0, 0, 0x0,  bhvCapSwitch, 31),
OBJECT_WITH_ACTS(212, -2809, -3579, 1306, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, 6938, -691, -6158, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(137, 5654, -617, -4944, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 6711, -617, -4944, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 2383, -2877, 1283, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4182, -2877, -3442, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -7474, -789, -5162, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 6278, -819, -1581, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4050, -1747, 3316, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 920, -2557, 2157, 0, 0, 0, 0x90000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 4179, -2557, -6178, 0, 0, 0, 0x90000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 4307, -1927, 3593, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(122, -5286, 3390, -3123, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(188, -761, -2277, -1506, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -864, -2577, -3443, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(122, -5477, -677, -4468, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(122, -424, -2877, 3205, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(122, -3948, -2877, 1410, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(0, 4183, -2877, -3442, 0, 0, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, -2220, -1377, 3012, 0, 270, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, -2617, -2463, -2082, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5746, -275, -2070, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(194, 5833, 353, 4414, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(180, 5834, 557, 5357, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 5396, 797, 6637, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(217, 1876, -3181, 4999, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(0, 1890, -2877, 4982, 0, 0, 0, 0x10000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, 2383, -2451, 1283, 0, 0, 0, 0x20000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(217, 2383, -2931, 1283, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(137, 6093, 449, 1345, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(23, 2961, -2877, -2238, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 2861, -2877, 1682, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -3301, -2877, 2821, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -300, -2877, 1384, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -1045, -2877, 828, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -1898, -2877, 2048, 0, 180, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(223, -2092, -2877, 1367, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 6066, -877, -5354, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, -1695, 559, 3166, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 770, -811, 2691, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 2575, -1579, 3211, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 6067, 23, 1315, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, -7330, 1290, 4713, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, -7346, 1290, 5907, 0, 180, 0, 0x40000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(23, 2945, -2877, -152, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(101, -6610, -2877, 4187, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(194, -792, -2217, -3555, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(0, -2357, 2568, 4657, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(192, 3878, -1747, 2673, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 1547, -2877, -3278, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -6912, 493, -3912, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(0, -4931, -1377, -3440, 0, 180, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(212, 1868, -2745, 4652, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, -2879, -2877, -5091, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(137, 920, -2557, 3910, 0, 0, 0, 0xf0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, -5093, 3390, -1377, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, 1957, 2023, 6455, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(137, 1957, 2497, 6455, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(180, -95, -692, -2710, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -4026, 725, -6313, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 5878, 329, -1995, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 6705, -1619, 5125, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 6704, -1565, 6027, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(207, -5054, 3390, -2280, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, -2015, -1377, 3254, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -2215, -1377, 3254, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -2015, -1377, 3054, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -2015, -1177, 3254, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -3570, 3090, -2435, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -3370, 3090, -2435, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -3370, 3090, -2635, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -3570, 3090, -2635, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -2470, 2990, -2835, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -2270, 2990, -2835, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -2470, 2990, -3035, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -2270, 2990, -3035, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -1370, 2890, -3235, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -1170, 2890, -3235, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -1370, 2890, -3435, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -1170, 2890, -3435, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -270, 2790, -3635, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -70, 2790, -3635, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -270, 2790, -3835, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -70, 2790, -3835, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(137, 1812, 3123, -4379, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -4671, 3690, -1000, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(124, 6877, -2877, -2747, 0, 180, 0, 0xa60000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, 1120, -600, 73, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(207, 6708, -1727, 6017, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, 6130, -1860, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6130, -1860, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6330, -1860, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6330, -1860, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 5120, -1860, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 5120, -1860, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 4920, -1860, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 4920, -1860, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 4920, -2060, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 4920, -2060, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6330, -2060, 2425, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6330, -2060, 2625, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
RETURN()
};

const LevelScript local_warps_totwc_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(1, 29, 1, 2, 0),
WARP_NODE(2, 29, 1, 1, 0),
WARP_NODE(240, 6, 3, 46, 0),
WARP_NODE(241, 6, 3, 56, 0),
RETURN()
};
